<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$database = new Database();
$db = $database->connect();
// Asumimos que el user_id=1 está logueado
$user_id = 1;

// Lógica de ejemplo: obtener 5 flashcards de dificultad media o alta
$query = "
    SELECT 
        s.name as subject_name, 
        'Tema General' as topic_name, 
        'Subtema' as subtopic_name, 
        COUNT(f.id) as card_count,
        f.difficulty,
        f.length
    FROM flashcards f
    JOIN subjects s ON f.subject_id = s.id
    WHERE f.user_id = :user_id AND (f.next_review IS NULL OR f.next_review <= CURDATE())
    GROUP BY s.name, f.difficulty, f.length
    ORDER BY f.difficulty DESC
";
$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$plan = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode($plan);
?>