<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));
$user_id = 1; // Asumimos user_id=1

if (empty($data->id)) {
    echo json_encode(['success' => false, 'message' => 'ID de flashcard requerido.']);
    exit;
}

$database = new Database();
$db = $database->connect();

$query = "DELETE FROM flashcards WHERE id = :id AND user_id = :user_id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $data->id);
$stmt->bindParam(':user_id', $user_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Flashcard eliminada.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al eliminar.']);
}
?>