<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$subject_id = isset($_GET['subject_id']) ? $_GET['subject_id'] : null;
$user_id = 1;

$database = new Database();
$db = $database->connect();

$query = "SELECT question, answer, difficulty, length, question_type FROM flashcards WHERE user_id = :user_id";
if ($subject_id) {
    $query .= " AND subject_id = :subject_id";
}

$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
if ($subject_id) {
    $stmt->bindParam(':subject_id', $subject_id);
}

$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($data);
?>