<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$database = new Database();
$db = $database->connect();
// Asumimos que el user_id=1 está logueado
$user_id = 1;

$query = "SELECT name as subject_name, exam_date, 'Examen Final' as title FROM subjects WHERE user_id = :user_id AND exam_date >= CURDATE() ORDER BY exam_date ASC LIMIT 5";
$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$exams = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode($exams);
?>