<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->username) || empty($data->password)) {
    echo json_encode(['success' => false, 'message' => 'Usuario y contraseña son requeridos.']);
    exit;
}

$database = new Database();
$db = $database->connect();

// Por simplicidad, este ejemplo no usa hashing real. 
// ¡EN UN ENTORNO REAL, USA password_hash() y password_verify()!
$query = "SELECT id, username FROM users WHERE username = :username AND password_hash = :password"; // Simplificado

$stmt = $db->prepare($query);
$stmt->bindParam(':username', $data->username);
// ¡NO HAGAS ESTO EN PRODUCCIÓN! Solo para demostración.
$dummy_hash = '$2y$10$9.B2.1/Z5K5C5f5f5F5e5u5G5h5i5j5k5l5m5n5o5p5q'; // Coincide con el hash de 'password123'
$stmt->bindParam(':password', $dummy_hash);

$stmt->execute();

if ($stmt->rowCount() > 0) {
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'success' => true,
        'token' => 'dummy_jwt_token_for_' . $user['id'], // Token de ejemplo
        'user' => [
            'id' => $user['id'],
            'username' => $user['username']
        ]
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Credenciales inválidas.']);
}
?>