<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));
// Asumimos que el user_id=1 está logueado
$user_id = 1;

if (empty($data->name)) {
    echo json_encode(['success' => false, 'message' => 'El nombre es requerido.']);
    exit;
}

$database = new Database();
$db = $database->connect();

$query = "INSERT INTO subjects (user_id, name) VALUES (:user_id, :name)";
$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->bindParam(':name', $data->name);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Asignatura creada.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al crear.']);
}
?>