<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$database = new Database();
$db = $database->connect();
$user_id = 1; // Asumimos user_id=1

$query = "
    SELECT f.id, f.question, f.answer, s.name as subject_name 
    FROM flashcards f
    JOIN subjects s ON f.subject_id = s.id
    WHERE f.user_id = :user_id AND (f.next_review IS NULL OR f.next_review <= CURDATE())
    LIMIT 10
";
$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$cards = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode($cards);
?>