<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));
$user_id = 1; // Asumimos user_id=1

if (empty($data->card_id) || empty($data->rating)) {
    echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
    exit;
}

// Lógica SMA simplificada
$new_interval = 1;
if ($data->rating == 'easy') $new_interval = 5;
if ($data->rating == 'medium') $new_interval = 2;

$database = new Database();
$db = $database->connect();

$query = "UPDATE flashcards SET last_reviewed = NOW(), next_review = DATE_ADD(CURDATE(), INTERVAL :interval_days DAY), interval_days = :interval_days WHERE id = :card_id AND user_id = :user_id";
$stmt = $db->prepare($query);
$stmt->bindParam(':interval_days', $new_interval);
$stmt->bindParam(':card_id', $data->card_id);
$stmt->bindParam(':user_id', $user_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al actualizar.']);
}
?>