<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));
$user_id = 1;

if (empty($data->subject_id) || empty($data->content)) {
    echo json_encode(['success' => false, 'message' => 'Faltan datos para importar.']);
    exit;
}

$database = new Database();
$db = $database->connect();
$db->beginTransaction();

try {
    if ($data->overwrite) {
        $del_stmt = $db->prepare("DELETE FROM flashcards WHERE user_id = :user_id AND subject_id = :subject_id");
        $del_stmt->bindParam(':user_id', $user_id);
        $del_stmt->bindParam(':subject_id', $data->subject_id);
        $del_stmt->execute();
    }

    $query = "INSERT INTO flashcards (user_id, subject_id, question, answer, difficulty, length, question_type) VALUES (:user_id, :subject_id, :question, :answer, :difficulty, :length, :question_type)";
    $stmt = $db->prepare($query);

    foreach ($data->content as $card) {
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':subject_id', $data->subject_id);
        $stmt->bindParam(':question', $card->question);
        $stmt->bindParam(':answer', $card->answer);
        $stmt->bindParam(':difficulty', $card->difficulty);
        $stmt->bindParam(':length', $card->length);
        $stmt->bindParam(':question_type', $card->question_type);
        $stmt->execute();
    }

    $db->commit();
    echo json_encode(['success' => true, 'message' => 'Importación completada.']);

} catch (Exception $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Error en la importación: ' . $e->getMessage()]);
}
?>