<?php
header("Content-Type: application/json; charset=UTF-8");
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));
$user_id = 1; // Asumimos user_id=1

// Validación simple
if (empty($data->subject_id) || empty($data->question) || empty($data->answer)) {
    echo json_encode(['success' => false, 'message' => 'Datos de flashcard incompletos.']);
    exit;
}

$database = new Database();
$db = $database->connect();

$query = "INSERT INTO flashcards (user_id, subject_id, question, answer, difficulty, length, question_type) VALUES (:user_id, :subject_id, :question, :answer, :difficulty, :length, :question_type)";
$stmt = $db->prepare($query);

$stmt->bindParam(':user_id', $user_id);
$stmt->bindParam(':subject_id', $data->subject_id);
$stmt->bindParam(':question', $data->question);
$stmt->bindParam(':answer', $data->answer);
$stmt->bindParam(':difficulty', $data->difficulty);
$stmt->bindParam(':length', $data->length);
$stmt->bindParam(':question_type', $data->question_type);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Flashcard creada.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al crear.']);
}
?>